<?php
/**
* @package phpBBex
* @copyright (c) 2015 phpBB Group, Vegalogic Software
* @license GNU Public License
*/

if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

$lang = array_merge($lang, [
	'ADMIN_CONFIG'				=> 'Настройки администратора',
	'ADMIN_PASSWORD'			=> 'Пароль администратора',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Подтверждение пароля администратора',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Введите пароль длиной от 6 до 30 символов.',
	'ADMIN_TEST'				=> 'Проверка настроек администратора',
	'ADMIN_USERNAME'			=> 'Имя администратора',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Введите имя длиной от 3 до 20 символов.',
	'AVAILABLE'					=> 'Доступно',

	'BACKUP_NOTICE'					=> 'Создайте резервную копию форума на случай возникновения проблем в процессе обновления.',

	'CATEGORY'					=> 'Категория',
	'CACHE_STORE'				=> 'Тип кэша',
	'CACHE_STORE_EXPLAIN'		=> 'Физическое расположение данных кэша, предпочтительная файловая система.',
	'CAT_CONVERT'				=> 'Конвертирование',
	'CAT_INSTALL'				=> 'Установка',
	'CAT_OVERVIEW'				=> 'Введение',
	'CAT_UPDATE'				=> 'Обновление',
	'CHANGE'					=> 'Изменить',
	'CHECK_TABLE_PREFIX'		=> 'Проверьте правильность префикса таблиц и попробуйте снова.',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Не удалось записать конфигурационный файл.',
	'CONFIG_FILE_WRITTEN'		=> 'Конфигурационный файл записан. Теперь вы можете приступить к следующему этапу установки.',
	'CONFIG_RETRY'				=> 'Повторить',
	'CONTINUE_LAST'				=> 'Продолжить выполнение заключительных операций',
	'CONVERT'					=> 'Конвертировать',

	'COULD_NOT_COPY'			=> 'Не удалось скопировать файл <strong>%1$s</strong> в <strong>%2$s</strong><br /><br />Проверьте, что конечный каталог существует и что в него может осуществляться запись.',
	'COULD_NOT_FIND_PATH'		=> 'Не удалось найти путь к старому форуму. Проверьте настройки и попробуйте снова.<br />» Путь %s был указан как исходный.',

	'DBMS'						=> 'Тип базы данных',
	'DB_CONFIG'					=> 'Конфигурация базы данных (БД)',
	'DB_CONNECTION'				=> 'Подключение к базе данных',
	'DB_HOST'					=> 'Имя сервера БД',
	'DB_HOST_EXPLAIN'			=> 'Обычно это localhost.',
	'DB_NAME'					=> 'Название базы данных',
	'DB_PASSWORD'				=> 'Пароль к БД',
	'DB_PORT'					=> 'Порт сервера БД',
	'DB_PORT_EXPLAIN'			=> 'Оставьте поле пустым, если сервер использует порт по умолчанию.',
	'DB_UPDATE_NOT_SUPPORTED'	=> 'К сожалению, данный сценарий не поддерживает обновление с версий phpBB до «%1$s». Установленная вами версия — «%2$s». Обновите предыдущую версию перед выполнением этого сценария. Помощь по этой проблеме можно найти на форумах поддержки на сайте phpBB.com.',
	'DB_USERNAME'				=> 'Имя пользователя БД',
	'DB_TEST'					=> 'Проверка подключения',
	'DEFAULT_LANG'				=> 'Язык форума по умолчанию',
	'DIRECTORIES_AND_FILES'		=> 'Настройка папок и файлов',
	'DISABLE_KEYS'				=> 'Отключение ключей',
	'DLL_FTP'					=> 'Поддержка удалённого FTP [ установка ]',
	'DLL_GD'					=> 'Поддержка графической библиотеки GD [ визуальное подтверждение ]',
	'DLL_MBSTRING'				=> 'Поддержка многобайтных символов',
	'DLL_MYSQL'					=> 'MySQL',
	'DLL_MYSQLI'				=> 'MySQL с расширением MySQLi',
	'DLL_XML'					=> 'Поддержка XML [ Jabber ]',
	'DLL_ZLIB'					=> 'Поддержка сжатия zlib [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'					=> 'Скачать файл конфигурации',
	'DL_CONFIG_EXPLAIN'			=> 'Вы можете целиком скачать файл config.php к себе на компьютер. Затем вам будет нужно вручную закачать этот файл в корневой каталог phpBBex, заменив исходный config.php. После того, как закачаете config.php, щелкните «Готово» для перехода к следующему шагу.',
	'DL_DOWNLOAD'				=> 'Скачать',
	'DONE'						=> 'Готово',

	'ENABLE_KEYS'				=> 'Восстановление ключей. Это действие может занять некоторое время.',

	'FILES_OPTIONAL'			=> 'Необязательные файлы и каталоги',
	'FILES_OPTIONAL_EXPLAIN'	=> 'Следующие файлы, каталоги или права доступа <strong>не являются обязательными</strong>. Программа установки попытается использовать различные методы для их создания, если они не существуют или если для них нет прав на запись. Тем не менее их наличие ускорит процесс установки.',
	'FILES_REQUIRED'			=> 'Файлы и каталоги',
	'FILES_REQUIRED_EXPLAIN'	=> 'Для правильной работы phpBBex <strong>необходим</strong> доступ на чтение или запись определённых файлов и каталогов. Если вы увидите надпись «Не найден», то необходимо создать соответствующий файл или каталог. А если увидите надпись «Нет прав на запись», то необходимо изменить права на файл или на каталог, чтобы разрешить phpBBex запись в них.',
	'FILLING_TABLE'				=> 'Заполнение таблицы <strong>%s</strong>',
	'FILLING_TABLES'			=> 'Заполнение таблиц',

	'FINAL_STEP'				=> 'Заключительный этап',
	'FOUND'						=> 'Найден',

	'GPL'						=> 'General Public License',

	'INITIAL_CONFIG'			=> 'Базовая конфигурация',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Программа установки определила, что phpBBex может работать на вашем сервере, и теперь вам необходимо ввести некоторые данные. Если вы не знаете, как подключиться к вашей базе данных, то свяжитесь со своим провайдером (в первую очередь) или обратитесь за помощью на наш форум поддержки. После ввода данных тщательно проверьте их перед отправкой.',
	'INSTALL_CONGRATS'			=> 'Поздравляем!',
	'INSTALL_CONGRATS_EXPLAIN'	=> 'Вы успешно установили phpBBex %1$s. Теперь вы можете начать использование только что установленного форума!',
	'INSTALL_INTRO'				=> 'Добро пожаловать в установку phpBBex!',
	'INSTALL_INTRO_BODY'		=> 'phpBBex — это расширенный форк классического движка форумов phpBB 3.0, который такой же легковесный, как и оригинал, в отличие от более новых версий phpBB. Соовместим с PHP 7.2+ и 8.0+.
	<p>Для установки phpBBex вам понадобятся следующие реквизиты доступа к базе данных MySQL:
	<ul>
		<li>Адрес сервера базы данных MySQL;</li>
		<li>Название базы данных;</li>
		<li>Логин и пароль для доступа к базе данных.</li>
	</ul>
	<p>Смотрите также:
	<ul>
		<li><a target="_blank" href="//phpbbex.com/">Официальный сайт phpBBex</a></li>
		<li><a target="_blank" href="//phpbbex.com/forum/viewtopic.php?t=2">Что нового в phpBBex?</a></li>
		<li><a target="_blank" href="//phpbbex.com/forum/viewtopic.php?t=8">FAQ</a></li>
		<li><a target="_blank" href="//phpbbex.com/forum/viewtopic.php?t=7">Конвертация базы из phpBB 3 в phpBBex</a></li>
	</ul>',
	'INSTALL_INTRO_NEXT'		=> 'Нажмите кнопку ниже, чтобы начать установку.',
	'INSTALL_LOGIN'				=> 'Вход',
	'INSTALL_NEXT'				=> 'Следующий этап',
	'INSTALL_NEXT_FAIL'			=> 'Часть проверок завершилась неудачно. Вам необходимо исправить найденные проблемы перед переходом к следующему этапу. В противном случае установка форума будет неоконченной.',
	'INSTALL_NEXT_PASS'			=> 'Все основные проверки пройдены, и вы можете перейти к следующему этапу установки. Если вы изменили какие-либо права, модули, и т. п., то вы можете повторно пройти проверки, нажав соответствующую кнопку.',
	'INSTALL_PANEL'				=> 'Установка phpBBex',
	'INSTALL_SEND_CONFIG'		=> 'К сожалению, не удалось записать конфигурацию phpBBex напрямую в файл config.php. Возможно, файл не существует, или отсутствуют права на запись. Ниже представлен список вариантов, позволяющих завершить установку config.php.',
	'INSTALL_START'				=> 'Начать установку',
	'INSTALL_TEST'				=> 'Повторная проверка',
	'INST_ERR'					=> 'Ошибка при установке',
	'INST_ERR_DB_CONNECT'		=> 'Не удалось подключиться к базе данных. Ниже показан текст сообщения об ошибке.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Указанный файл базы данных находится в каталоге форума. Необходимо переместить его в каталог, недоступный из интернета.',
	'INST_ERR_DB_INVALID_PREFIX'=> 'Указан неправильный префикс. Он должен начинаться с буквы и может содержать только буквы, числа и знаки подчёркивания.',
	'INST_ERR_DB_NO_ERROR'		=> 'Нет сообщения об ошибке.',
	'INST_ERR_DB_NO_MYSQLI'		=> 'Для работы требуется MySQL 5.5 и новее.',
	'INST_ERR_DB_NO_NAME'		=> 'Не указано название базы данных.',
	'INST_ERR_EMAIL_INVALID'	=> 'Введенный адрес email недопустим.',
	'INST_ERR_FATAL'			=> 'Критическая ошибка при установке',
	'INST_ERR_FATAL_DB'			=> 'Произошла критическая ошибка при работе с базой данных. Установка прервана. Причиной может быть отсутствие необходимых прав на выполнение операций создания и добавления данных (<code>CREATE TABLES</code>, <code>INSERT</code> или аналогичных). Более подробная информация предоставлена ниже. Свяжитесь со своим провайдером или обратитесь на форум поддержки phpBBex за дополнительной информацией.',
	'INST_ERR_FTP_PATH'			=> 'Не удалось перейти в заданный каталог. Убедитесь в правильности относительного пути.',
	'INST_ERR_FTP_LOGIN'		=> 'Не удалось войти на FTP-сервер. Проверьте правильность ввода имени пользователя и пароля.',
	'INST_ERR_MISSING_DATA'		=> 'На этой странице необходимо заполнить все поля.',
	'INST_ERR_NO_DB'			=> 'Не удалось загрузить модуль PHP для выбранного типа базы данных.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Введённые пароли не совпадают.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Введённый пароль слишком длинный. Длина пароля не должна превышать 30 символов.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Введённый пароль слишком короткий. Минимальная длина пароля — 6 символов.',
	'INST_ERR_PREFIX'			=> 'Таблицы с указанным префиксом уже существуют. Введите другой префикс.',
	'INST_ERR_PREFIX_INVALID'	=> 'Указанный префикс недопустим для вашей базы данных. Введите другой префикс без специальных символов типа дефиса.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Указанный префикс таблиц слишком длинный. Длина префикса не должна превышать %d символов.',
	'INST_ERR_USER_TOO_LONG'	=> 'Введённое имя пользователя слишком длинное. Длина имени пользователя не должна превышать 20 символов.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Введённое имя пользователя слишком короткое. Минимальная длина имени пользователя — 3 знака.',
	'INVALID_PRIMARY_KEY'		=> 'Недопустимый первичный ключ: %s',

	'LONG_SCRIPT_EXECUTION'		=> 'Выполнение может занять некоторое время… Пожалуйста, не останавливайте процесс.',

	// mbstring
	'MBSTRING_CHECK'						=> 'Проверка расширения <samp>mbstring</samp>',
	'MBSTRING_CHECK_EXPLAIN'				=> '<strong>Необходимо</strong>. <samp>mbstring</samp> — это расширение PHP, обеспечивающее работу многобайтных строковых функций. Некоторые возможности mbstring несовместимы с phpBBex и должны быть отключены.',
	'MBSTRING_FUNC_OVERLOAD'				=> 'Перегрузка функции',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'		=> 'Значение <var>mbstring.func_overload</var> должно быть установлено в 0 или в 4.',
	'MBSTRING_ENCODING_TRANSLATION'			=> 'Прозрачное кодирование символов',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> 'Значение <var>mbstring.encoding_translation</var> должно быть установлено в 0.',
	'MBSTRING_HTTP_INPUT'					=> 'Кодировка входящих символов',
	'MBSTRING_HTTP_INPUT_EXPLAIN'			=> 'Значение <var>mbstring.http_input</var> должно быть установлено в <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'					=> 'Кодировка исходящих символов',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'			=> 'Значение <var>mbstring.http_output</var> должно быть установлено в <samp>pass</samp>.',

	'MAKE_FOLDER_WRITABLE'		=> 'Убедитесь, что этот каталог существует и у сервера есть права на запись в него, затем повторите попытку:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'		=> 'Убедитесь, что эти каталоги существуют и у сервера есть права на запись в них, затем повторите попытку:<br />»<strong>%s</strong>.',

	'NEXT_STEP'					=> 'Следующий шаг',
	'NOT_FOUND'					=> 'Не найден',

	'OVERVIEW_BODY'					=> 'Добро пожаловать в phpBBex!<br /><br />phpBBex (phpBB extended) — это попытка создать более продвинутую версию phpBB, которая при этом останется просто форумом, а не комбайном на все случаи жизни. Разработка phpBBex ведётся на профессиональном уровне, исходные коды находятся под контролем системы управления версиями Mercurial. Большинство проделанных изменений не существует в виде модов. Практически все установленные моды (из существующих вне phpBBex) были сильно переработаны: исправлены ошибки, код адаптирован под последние версии phpBB. Если phpBBex без дополнительных модификаций вас устраивает больше, чем стандартный phpBB 3 — несомненно, phpBBex станет для вас верным помощником. <a href="//phpbbex.com/forum/viewtopic.php?t=2">Подробнее...</a><br /><br />Эта система проведёт вас через процессы установки phpBBex. Для получения дополнительной информации мы предлагаем вам ознакомиться с <a href="../docs/INSTALL.html">руководством по установке</a>. Для установки выберите соответствующую закладку выше.',

	'PCRE_UTF_SUPPORT'				=> 'Поддержка UTF-8 и конструкции "(?|(a)|(b))" в PCRE',
	'PCRE_UTF_SUPPORT_EXPLAIN'		=> 'phpBBex <strong>не будет</strong> работать, если PHP собран без поддержки UTF-8 для регулярных выражений или используется слишком старая версия PCRE.',
	'PHP_GETIMAGESIZE_SUPPORT'			=> 'Функция PHP getimagesize() доступна',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Необходима</strong>. Для правильной работы phpBBex необходимо наличие функции getimagesize.',
	'PHP_OPTIONAL_MODULE'			=> 'Необязательные модули',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> 'Эти модули и приложения <strong>не являются обязательными</strong>. Тем не менее они предоставляют расширенные возможности будущего форума.',
	'PHP_SUPPORTED_DB'				=> 'Поддерживаемые базы данных',
	'PHP_SUPPORTED_DB_EXPLAIN'		=> 'Ваша версия PHP должна поддерживать <strong>не менее одной</strong> из поддерживаемых баз данных.',
	'PHP_SETTINGS'					=> 'Версия и настройки PHP',
	'PHP_SETTINGS_EXPLAIN'			=> 'Для установки phpBBex <strong>требуется</strong> версия PHP не ниже 7.2.',
	'PHP_URL_FOPEN_SUPPORT'			=> 'Параметр PHP <var>allow_url_fopen</var> включён',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>Необязательно</strong>. Хотя этот параметр не является обязательным, некоторые функции phpBBex, типа внешних аватар, не будут работать должным образом. ',
	'PHP_VERSION_REQD'				=> 'Версия PHP ≥ 7.2',
	'POST_ID'						=> 'Идентификатор сообщения',

	'REQUIREMENTS_TITLE'		=> 'Программная совместимость',
	'REQUIREMENTS_EXPLAIN'		=> 'Перед установкой phpBBex будут проведены проверки файлов и конфигурации сервера, чтобы удостовериться в том, что phpBBex можно установить и запустить. Внимательно ознакомьтесь с результатами и не переходите к следующему шагу установки до тех пор, пока необходимые проверки не будут пройдены. Если вам нужны какие-либо из дополнительных возможностей форума, убедитесь, что соответствующие им тесты также успешно пройдены.',
	'RETRY_WRITE'				=> 'Повторить попытку записи конфигурации',
	'RETRY_WRITE_EXPLAIN'		=> 'При желании вы можете изменить права на файл config.php, чтобы разрешить phpBBex запись в него. В этом случае нажмите на кнопку «Повторить» ниже. Не забудьте вернуть права на файл config.php после завершения установки.',

	'SELECT_LANG'				=> 'Выберите язык',
	'SERVER_CONFIG'				=> 'Конфигурация сервера',
	'SOFTWARE'					=> 'Тип форума',
	'SPECIFY_OPTIONS'			=> 'Определение настроек конвертирования',
	'STAGE_ADMINISTRATOR'		=> 'Сведения об администраторе',
	'STAGE_ADVANCED'			=> 'Дополнительные параметры',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Изменять параметры на этой странице необходимо лишь в том случае, если вы знаете, что вам не подойдут настройки по умолчанию. Если вы не уверены, то пропустите эту страницу и смело переходите к следующему этапу установки — все эти настройки можно будет изменить позже в панели администратора.',
	'STAGE_CONFIG_FILE'			=> 'Файл конфигурации',
	'STAGE_CREATE_TABLE'		=> 'Создание таблиц базы данных',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Таблицы базы данных phpBBex созданы и заполнены начальными данными. Перейдите к следующему этапу для завершения установки phpBBex.',
	'STAGE_DATABASE'			=> 'Настройки базы данных',
	'STAGE_FINAL'				=> 'Заключительный этап',
	'STAGE_INTRO'				=> 'Введение',
	'STAGE_IN_PROGRESS'			=> 'Конвертирование',
	'STAGE_REQUIREMENTS'		=> 'Требования',
	'STAGE_SETTINGS'			=> 'Параметры',
	'STEP_PERCENT_COMPLETED'	=> 'Этап <strong>%d</strong> из <strong>%d</strong>',
	'SUB_INTRO'					=> 'Введение',
	'SUB_LICENSE'				=> 'Лицензия',
	'SUB_SUPPORT'				=> 'Поддержка',
	'SUCCESSFUL_CONNECT'		=> 'Успешное подключение',

	'TABLE_PREFIX'				=> 'Префикс для таблиц в базе данных',
	'TABLE_PREFIX_EXPLAIN'		=> 'Префикс должен начинаться с буквы и может содержать только буквы, числа и знаки подчёркивания.',
	'TESTS_PASSED'				=> 'Проверки пройдены',
	'TESTS_FAILED'				=> 'Проверки не пройдены',

	'UNABLE_WRITE_LOCK'			=> 'Не удалось записать файл блокировки.',
	'UNAVAILABLE'				=> 'Недоступно',
	'UNWRITABLE'				=> 'нет прав на запись',
	'UPDATE_TOPICS_POSTED'		=> 'Создание списка тем, в которых писал пользователь',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Произошла ошибка при создание списка тем, в которых писал пользователь. Вы можете повторить попытку выполнить этот этап в панели администратора после завершения процесса преобразования.',
	'VERIFY_OPTIONS'			=> 'Проверка настроек конвертирования',
	'VERSION'					=> 'Версия',

	'WELCOME_INSTALL'			=> 'Вас приветствует программа установки phpBBex.',
	'WRITABLE'					=> 'допускает запись',
]);

// Updater
$lang = array_merge($lang, [
	'ALL_FILES_UP_TO_DATE'		=> 'Все файлы соответствуют самой последней версии phpBB. Теперь <a href="../ucp.php?mode=login">войдите на форум</a> и проверьте, что всё работает нормально.',
	'ARCHIVE_FILE'				=> 'Файл-источник в архиве',

	'BACK'				=> 'Назад',
	'BINARY_FILE'		=> 'Бинарный файл',
	'BOT'				=> 'Паук/Робот',

	'CHANGE_CLEAN_NAMES'			=> 'Метод, используемый для проверки на использование одного и того же имени несколькими пользователями, был изменён. Имеется несколько пользователей, имеющих одно и то же имя при сравнении новым методом. Для продолжения необходимо удалить или переименовать этих пользователей, чтобы удостовериться, что каждое имя используется только одним пользователем.',
	'CHECK_FILES'					=> 'Сравнить файлы',
	'CHECK_FILES_AGAIN'				=> 'Повторно сравнить файлы',
	'CHECK_FILES_EXPLAIN'			=> 'На следующем этапе все файлы будут сравнены с файлами обновления. Это действие может занять некоторое время, если сравнение файлов проводится впервые.',
	'CHECK_FILES_UP_TO_DATE'		=> 'Согласно информации, находящейся в базе данных, ваша версия phpBB самая новая. Вы можете приступить к сравнению файлов, чтобы убедиться в том, что все файлы действительно соответствуют самой последней версии phpBB.',
	'CHECK_UPDATE_DATABASE'			=> 'Продолжить обновление',
	'COLLECTED_INFORMATION'			=> 'Сведения о файлах',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'Список ниже демонстрирует сведения о файлах, нуждающихся в обновлении. Прочтите информацию, предшествующую блоку файлов каждого типа, чтобы понять их смысл и что требуется сделать для выполнения успешного обновления.',
	'COLLECTING_FILE_DIFFS'			=> 'Проверка различий в файлах',
	'CONTINUE_UPDATE_NOW'			=> 'Продолжайте процесс обновления',		// Shown within the database update script at the end if called from the updater
	'CONTINUE_UPDATE'				=> 'Продолжайте обновление',				// Shown after file upload to indicate the update process is not yet finished
	'CURRENT_FILE'					=> 'Начало конфликта — код исходного файла до обновления',
	'CURRENT_VERSION'				=> 'Текущая версия',

	'DATABASE_TYPE'						=> 'Тип базы данных',
	'DATABASE_UPDATE_INFO_OLD'			=> 'Файл обновления базы данных в каталоге install устарел. Убедитесь, что закачали исправную версию этого файла.',
	'DELETE_USER_REMOVE'				=> 'Удалить пользователя и его сообщения',
	'DELETE_USER_RETAIN'				=> 'Удалить пользователя, но оставить его сообщения',
	'DESTINATION'						=> 'Файл-получатель',
	'DIFF_INLINE'						=> 'Внутри текста',
	'DIFF_RAW'							=> 'Код объединённых различий',
	'DIFF_SEP_EXPLAIN'					=> 'Код, используемый в обновлённом файле',
	'DIFF_SIDE_BY_SIDE'					=> 'Параллельно',
	'DIFF_UNIFIED'						=> 'Объединённые различия',
	'DO_NOT_UPDATE'						=> 'Не обновлять этот файл',
	'DONE'								=> 'Готово',
	'DOWNLOAD'							=> 'Скачать',
	'DOWNLOAD_AS'						=> 'Скачать в формате',
	'DOWNLOAD_UPDATE_METHOD_BUTTON'		=> 'Скачать архив с модифицированными файлами (рекомендуется)',
	'DOWNLOAD_CONFLICTS'				=> 'Скачать конфликтные места для этого файла',
	'DOWNLOAD_CONFLICTS_EXPLAIN'		=> 'Искать &lt;&lt;&lt; для выявления конфликтов',
	'DOWNLOAD_UPDATE_METHOD'			=> 'Скачать архив с модифицированными файлами',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Скачав архив, распакуйте его. В нём вы найдёте измененные файлы, которые нужно закачать в корень phpBB, при этом каждый файл должен оказаться в соответствующем ему каталоге. После этого снова проведите сравнение файлов, нажав отвечающую за это кнопку ниже.',

	'ERROR'			=> 'Ошибка',
	'EDIT_USERNAME'	=> 'Изменить имя пользователя',

	'FILE_ALREADY_UP_TO_DATE'		=> 'Файл уже соответствует новой версии.',
	'FILE_DIFF_NOT_ALLOWED'			=> 'Нет прав на выполнение команды diff для этого файла.',
	'FILE_USED'						=> 'Информация из файла',			// Single file
	'FILES_CONFLICT'				=> 'Конфликтующие файлы',
	'FILES_CONFLICT_EXPLAIN'		=> 'Следующие файлы модифицированы и не соответствуют оригинальным файлам старой версии. phpBB определил, что эти файлы будут создавать конфликт при объединении их с новыми версиями. Изучите конфликтные места и попытайтесь исправить их вручную, либо продолжите обновление, выбрав подходящий тип объединения файлов. Если вы будете разрешать конфликты вручную, то снова проведите сравнение файлов после внесения в них изменений. Для каждого файла в отдельности вы можете выбрать предпочтительный метод объединения с новой версией. Результатом работы первого метода будет файл, в котором отброшены конфликтующие строки из вашего старого файла, во втором методе будут отброшены конфликтующие строки из новой версии.',
	'FILES_MODIFIED'				=> 'Изменённые файлы',
	'FILES_MODIFIED_EXPLAIN'		=> 'Следующие файлы модифицированы и не соответствуют оригинальным файлам старой версии. Обновлённый файл будет результатом объединения вашего модифицированного и нового файла.',
	'FILES_NEW'						=> 'Новые файлы',
	'FILES_NEW_EXPLAIN'				=> 'Следующих файлов нет в вашей версии phpBB. Эти файлы будут добавлены.',
	'FILES_NEW_CONFLICT'			=> 'Новые конфликтующие файлы',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Следующие файлы появились лишь в последней версии. Но файл с таким же именем и в том же месте уже существует. Этот файл будет перезаписан файлом из новой версии.',
	'FILES_NOT_MODIFIED'			=> 'Неизменённые файлы',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Следующие файлы не были изменены и представляют собой оригинальные файлы phpBB той версии, которую вы хотите обновить.',
	'FILES_UP_TO_DATE'				=> 'Уже обновлённые файлы',
	'FILES_UP_TO_DATE_EXPLAIN'		=> 'Следующие файлы уже соответствуют файлам новой версии и не нуждаются в обновлении.',
	'FTP_SETTINGS'					=> 'Настройки FTP',
	'FTP_UPDATE_METHOD'				=> 'Закачать по FTP',

	'INCOMPATIBLE_UPDATE_FILES'		=> 'Найденные файлы обновления не подходят для установленной версии phpBB. Ваша версия — %1$s, а файл обновления предназначен для перехода с версии %2$s к версии %3$s.',
	'INCOMPLETE_UPDATE_FILES'		=> 'Неполный набор файлов обновления.',
	'INLINE_UPDATE_SUCCESSFUL'		=> 'Обновление базы данных успешно завершено. Теперь необходимо продолжить процесс обновления.',

	'KEEP_OLD_NAME'		=> 'Оставить прежнее имя',

	'LATEST_VERSION'		=> 'Последняя версия',
	'LINE'					=> 'Строка',
	'LINE_ADDED'			=> 'Добавлено',
	'LINE_MODIFIED'			=> 'Изменено',
	'LINE_REMOVED'			=> 'Удалено',
	'LINE_UNMODIFIED'		=> 'Не изменено',
	'LOGIN_UPDATE_EXPLAIN'	=> 'Для того, чтобы обновить версию phpBB, сперва необходимо войти на форум.',

	'MAPPING_FILE_STRUCTURE'	=> 'Для облегчения закачки файлов здесь указаны соответствия расположений файлов в архиве и в вашей версии phpBB.',

	'MERGE_MODIFICATIONS_OPTION'	=> 'Объединить изменения',

	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Не объединять — использовать новый файл',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'Не объединять — использовать имеющийся файл',
	'MERGE_MOD_FILE_OPTION'		=> 'Объединить изменения (удалить новый код в конфликтном месте)',
	'MERGE_NEW_FILE_OPTION'		=> 'Объединить изменения (удалить изменённый код в конфликтном месте)',
	'MERGE_SELECT_ERROR'		=> 'Неверно выбраны способы объединения конфликтного файла с новой версией.',
	'MERGING_FILES'				=> 'Объединение различий',
	'MERGING_FILES_EXPLAIN'		=> 'Сейчас производится окончательное изменение файлов.<br /><br />Дождитесь окончания всех операций по изменению файлов.',

	'NEW_FILE'						=> 'Конец конфликтного места',
	'NEW_USERNAME'					=> 'Новое имя',
	'NO_AUTH_UPDATE'				=> 'У вас нет прав на выполнение обновления phpBB',
	'NO_ERRORS'						=> 'Без ошибок',
	'NO_UPDATE_FILES'				=> 'Следующие файлы не будут обновлены',
	'NO_UPDATE_FILES_EXPLAIN'		=> 'Следующие файлы появились или были изменены в последней версии, но каталог, в котором они должны находиться, не найден в текущей версии phpBB. Присутствие в списке файлов, не относящихся к каталогу языков (language/) или стилей (styles/), может означать, что вы изменили структуру каталогов и обновление будет неполным.',
	'NO_UPDATE_FILES_OUTDATED'		=> 'Не найден каталог с обновлениями, убедитесь, что вы закачали соответствующие файлы.<br /><br />Ваша версия phpBB %1$s <strong>не</strong> самая последняя, для неё доступны обновления. Зайдите на страницу <a href="http://www.phpbb.com/downloads/" rel="external">http://www.phpbb.com/downloads/</a>, чтобы скачать нужный вам пакет обновления с версии %2$s до версии %3$s.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Ваша версия phpBB самая последняя. Нет необходимости запускать программу обновления. Если вы хотите провести проверку целостности файлов, удостоверьтесь, что закачали подходящие файлы обновления.',
	'NO_UPDATE_INFO'				=> 'Не найдены данные файла обновления.',
	'NO_UPDATES_REQUIRED'			=> 'Обновление не требуется',
	'NO_VISIBLE_CHANGES'			=> 'Нет видимых изменений',
	'NOTICE'						=> 'Уведомление',
	'NUM_CONFLICTS'					=> 'Число конфликтных мест',
	'NUMBER_OF_FILES_COLLECTED'	=> 'Проверены различия в %1$d файлах из %2$d.<br />Дождитесь полной проверки всех файлов.',

	'PACKAGE_UPDATES_TO'				=> 'Текущий пакет обновляет до версии',
	'PERFORM_DATABASE_UPDATE'			=> 'Обновление базы данных',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Ниже вы найдёте кнопку обновления базы данных. Обновление может занять некоторое время, поэтому не прерывайте процесс его выполнения, если вам покажется, что он завис. После завершения следуйте инструкциям для продолжения процесса обновления.',
	'PREVIOUS_VERSION'					=> 'Предыдущая версия',
	'PROGRESS'							=> 'Ход выполнения',

	'RESULT'					=> 'Результат',
	'RUN_DATABASE_SCRIPT'		=> 'Обновить базу данных',

	'SELECT_DIFF_MODE'			=> 'Выберите режим diff',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Выберите формат архива для скачивания',
	'SELECT_FTP_SETTINGS'		=> 'Установка настроек FTP',
	'SHOW_DIFF_CONFLICT'		=> 'Различия/конфликтные места',
	'SHOW_DIFF_FINAL'			=> 'Итоговый файл',
	'SHOW_DIFF_MODIFIED'		=> 'Различия с объединённым файлом',
	'SHOW_DIFF_NEW'				=> 'Содержимое файла',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Различия в файлах',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Различия в файлах',
	'SOME_QUERIES_FAILED'		=> 'Выполнение некоторых запросов завершилось неудачей, тексты запросов и ошибок приведены ниже.',
	'SQL'						=> 'SQL-запрос',
	'SQL_FAILURE_EXPLAIN'		=> 'Скорее всего, волноваться не о чем, процесс обновления будет продолжен. Если он не будет завершён, то поищите справку на нашем форуме поддержки. Для получения сведений о получении поддержки смотрите файл <a href="../docs/README.html">README</a>.',
	'STAGE_FILE_CHECK'			=> 'Проверка файлов',
	'STAGE_UPDATE_DB'			=> 'Обновление базы данных',
	'STAGE_UPDATE_FILES'		=> 'Обновление файлов',
	'STAGE_VERSION_CHECK'		=> 'Проверка версии',
	'STATUS_CONFLICT'			=> 'Изменённый файл, создающий конфликты',
	'STATUS_MODIFIED'			=> 'Изменённый файл',
	'STATUS_NEW'				=> 'Новый файл',
	'STATUS_NEW_CONFLICT'		=> 'Конфликтующий новый файл',
	'STATUS_NOT_MODIFIED'		=> 'Неизменённый файл',
	'STATUS_UP_TO_DATE'			=> 'Уже обновлённый файл',

	'TOGGLE_DISPLAY'			=> 'Показать/скрыть список файлов',
	'TRY_DOWNLOAD_METHOD'		=> 'Вы можете попробовать загрузить изменённые файлы.<br />Этот метод наиболее надёжен и является рекомендуемым способом обновления.',
	'TRY_DOWNLOAD_METHOD_BUTTON'=> 'Попробовать этот метод',

	'UPDATE_COMPLETED'				=> 'Обновление завершено',
	'UPDATE_DATABASE'				=> 'Обновить базу данных',
	'UPDATE_DATABASE_EXPLAIN'		=> 'На следующем этапе будут внесены необходимые изменения в базу данных.',
	'UPDATE_DATABASE_SCHEMA'		=> 'Обновление структуры базы данных',
	'UPDATE_FILES'					=> 'Обновить файлы',
	'UPDATE_FILES_NOTICE'			=> 'Убедитесь в том, что вы также обновили файлы форума. Этот файл обновляет только базу данных.',
	'UPDATE_INSTALLATION'			=> 'Обновление версии phpBB',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Здесь вы можете обновить вашу версию phpBB до последней.<br />Во время этого процесса все ваши файлы будут проверены на целостность. Вы сможете просмотреть файлы и вносимые в них изменения перед обновлением.<br /><br />Само обновление может быть выполнено двумя способами.</p><h2>Обновление вручную</h2><p>Этот способ заключается в том, что вы скачиваете индивидуальный набор обновлённых файлов, чтобы не потерять сделанные вами изменения в имеющихся файлах. Скачав этот архив, вы должны вручную закачать файлы из него в соответствующие им местоположения относительно корневого каталога phpBB. После этого вам будет дана возможность провести проверку, что все файлы занимают полагающиеся им места.</p><h2>Автоматическое обновление по FTP</h2><p>Этот способ похож на первый, но без необходимости скачивать обновлённые файлы и закачивать их на сервер самостоятельно, это будет сделано за вас. Чтобы воспользоваться этим способом, вам нужно знать запрашиваемые программой обновления данные о вашем FTP-сервере. По окончании вы будете направлены на повторное сравнение файлов с целью удостовериться, что обновление прошло успешно.<br /><br />',
	'UPDATE_INSTRUCTIONS'			=> 'Доступна новая версия: <strong>%1$s</strong>. Прочтите дополнительные сведения, чтобы получить информацию о нововведениях и способах обновления.',
	'UPDATE_METHOD'					=> 'Способ обновления',
	'UPDATE_METHOD_EXPLAIN'			=> 'Сейчас вы можете выбрать удобный для вас способ закачки файлов. Если вы предпочтёте закачку по FTP, вам будет предложено заполнить форму данных об учётной записи вашего FTP-сервера. Этот способ обеспечивает автоматическое перемещение файлов в новые местоположения и создание резервных копий их старых версий с добавлением .bak к имени файла. Если вы выберите скачивание архива с модифицированными файлами, то сможете распаковать его и закачать файлы в соответствующие им местоположения вручную.',
	'UPDATE_REQUIRES_FILE'			=> 'Для обновления необходимо наличие следующего файла: %s',
	'UPDATE_SUCCESS'				=> 'Обновление успешно завершено',
	'UPDATE_SUCCESS_EXPLAIN'		=> 'Все файлы успешно обновлены. Следующий шаг включает в себя повторную проверку соответствия файлов последней версии phpBB.',
	'UPDATE_VERSION_OPTIMIZE'		=> 'Обновление версии и оптимизация таблиц',
	'UPDATING_DATA'					=> 'Обновление данных',
	'UPDATING_TO_LATEST_STABLE'		=> 'Обновление базы данных до последней стабильной версии',
	'UPDATED_VERSION'				=> 'Обновлённая версия',
	'UPGRADE_INSTRUCTIONS'			=> 'Доступна новая версия: <strong>%1$s</strong>. Прочтите <a href="%2$s" title="%2$s"><strong>объявление о выходе новой версии</strong></a>, чтобы получить информацию о нововведениях и способах обновления.',
	'UPLOAD_METHOD'					=> 'Способ закачки',

	'UPDATE_DB_SUCCESS'				=> 'База данных успешно обновлена.',
	'USER_ACTIVE'					=> 'Активированный пользователь',
	'USER_INACTIVE'					=> 'Неактивированный пользователь',

	'VERSION_CHECK'					=> 'Проверка версии',
	'VERSION_CHECK_EXPLAIN'			=> 'Проверяет, что текущая версия phpBB самая последняя.',
	'VERSION_NOT_UP_TO_DATE'		=> 'Ваша версия phpBB не самая последняя. Продолжайте процесс обновления.',
	'VERSION_NOT_UP_TO_DATE_ACP'	=> 'Ваша версия phpBB не самая последняя.<br />Ниже вы найдёте ссылку на объявление о выпуске последней версии, которое содержит дополнительную информацию, а также инструкции по обновлению phpBB.',
	'VERSION_NOT_UP_TO_DATE_TITLE'	=> 'Ваша версия phpBB не самая последняя.',
	'VERSION_UP_TO_DATE'			=> 'Ваша версия phpBB самая последняя. На данный момент для неё нет обновлений. Тем не менее вы можете перейти к проверке файлов на соответствие последней версии.',
	'VERSION_UP_TO_DATE_ACP'		=> 'Ваша версия phpBB самая последняя. На данный момент для неё нет обновлений.',
	'VIEWING_FILE_CONTENTS'			=> 'Просмотр содержимого файла',
	'VIEWING_FILE_DIFF'				=> 'Просмотр различий в файлах',

	'WRONG_INFO_FILE_FORMAT'	=> 'Ошибочный формат файла сведений об обновлении',
]);

// Default database schema entries…
$lang = array_merge($lang, [
	'CONFIG_BOARD_EMAIL_SIG'		=> 'Спасибо, Администрация',
	'CONFIG_SITE_DESC'				=> 'Краткое описание вашего форума',
	'CONFIG_SITENAME'				=> 'Ваш phpBBex',

	'DEFAULT_INSTALL_POST'			=> 'Это пример сообщения на вашем новом форуме phpBBex. Вы можете удалить это сообщение и продолжить настройку вашего форума. В процессе установки вашей первой категории и первому разделу были заданы подходящие права доступа для предустановленных групп администраторов, супермодераторов, гостей и зарегистрированных пользователей. Если вы решите удалить вашу первую категорию и первый раздел, не забудьте установить права доступа для всех новых категорий и разделов, которые вы создаёте. Рекомендуем переименовать вашу первую категорию и первый раздел и копировать права доступа с них вновь создаваемым категориям и разделам. Удачи!',

	'FORUMS_FIRST_CATEGORY'			=> 'Ваша первая категория',
	'FORUMS_TEST_FORUM_DESC'		=> 'Описание вашего первого раздела.',
	'FORUMS_TEST_FORUM_TITLE'		=> 'Ваш первый раздел',

	'RANKS_SITE_ADMIN_TITLE'		=> 'Администратор',
	'REPORT_WAREZ'					=> 'Сообщение содержит ссылки на незаконные или пиратские программы.',
	'REPORT_SPAM'					=> 'Сообщение имеет единственной целью рекламу сайтов, программ или других продуктов, товаров, услуг и пр.',
	'REPORT_OFF_TOPIC'				=> 'Сообщение не относится к обсуждаемой теме.',
	'REPORT_OTHER'					=> 'Причина обжалования не относится ни к одной из перечисленных, используйте поле дополнительной информации.',

	'TOPICS_TOPIC_TITLE'			=> 'Добро пожаловать в phpBBex',

	'WARNING_POST_DEFAULT'			=> 'Нарушение правил',
	'BOARD_DISABLE_DEFAULT'			=> 'Извините, идет обновление форума. Зайдите через 1 час.',
]);
