<?php
/**
* @package phpBBex
* @copyright (c) 2015 phpBB Group, Vegalogic Software
* @license GNU Public License
*/

if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

$lang = array_merge($lang, [
	'DATE_FORMAT'		=> '|d.m.Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'ru',

	'1_DAY'			=> '1 день',
	'1_MONTH'		=> '1 месяц',
	'1_YEAR'		=> '1 год',
	'2_WEEKS'		=> '2 недели',
	'3_MONTHS'		=> '3 месяца',
	'6_MONTHS'		=> '6 месяцев',
	'7_DAYS'		=> '7 дней',
	'ALL_DAYS'		=> 'Все дни',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ваша учётная запись уже была активирована.',
	'ACCOUNT_DEACTIVATED'			=> 'Ваша учётная запись была отключена вручную и может быть вновь активирована только администратором форума.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Ваша учётная запись ещё не активирована.',
	'ACP'							=> 'Панель администратора',
	'ACTIVE'						=> 'активен',
	'ADMINISTRATOR'					=> 'Администратор',
	'ADMINISTRATORS'				=> 'Администраторы',
	'AGE'							=> 'Возраст',
	'ALLOWED'						=> 'Разрешено',
	'ALL_FILES'						=> 'Все файлы',
	'ALL_FORUMS'					=> 'Все разделы',
	'ALL_MESSAGES'					=> 'Все сообщения',
	'ALL_POSTS'						=> 'Все сообщения',
	'ALL_TOPICS'					=> 'Все темы',
	'AND'							=> 'и',
	'ARE_WATCHING_FORUM'			=> 'Вы подписаны на уведомления о новых сообщениях в этом разделе.',
	'ARE_WATCHING_TOPIC'			=> 'Вы подписаны на уведомления о новых сообщениях в этой теме.',
	'ASCENDING'						=> 'по возрастанию',
	'ATTACHMENTS'					=> 'Вложения',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Вы попытались отправить недопустимый тип файла изображения.',
	'AUTHOR'						=> 'Автор',
	'AUTH_NO_PROFILE_CREATED'		=> 'Не удалось создать профиль пользователя.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Закачка была отклонена, так как вложение было определено как возможная атака.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Данный файл не может быть отображён, поскольку расширение <strong>%s</strong> не разрешено',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Не удалось загрузить указанную аватару. Возможно, данные повреждены или недопустимы.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Загруженный файл аватары пуст.',
	'AVATAR_INVALID_FILENAME'		=> '%s является недопустимым именем файла.',
	'AVATAR_NOT_UPLOADED'			=> 'Загрузка аватары не удалась.',
	'AVATAR_NO_SIZE'				=> 'Не удалось определить размеры указанной аватары. Пожалуйста, введите их вручную.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Указанный файл загружен только частично',
	'AVATAR_PHP_SIZE_NA'			=> 'Слишком большой размер файла аватары.<br />Не удалось определить максимальный размер, установленный в php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Слишком большой размер файла аватары. Максимально допустимый размер — %1$d %2$s.<br />Примечание: это ограничение установлено в файле php.ini и не может быть превышено.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Аватара не может быть загружена из-за превышения времени ожидания ответа сервера на запрос.',
	'AVATAR_URL_INVALID'			=> 'Указанный адрес аватары недопустим.',
	'AVATAR_URL_NOT_FOUND'			=> 'Указанный файл аватары не найден.',
	'AVATAR_WRONG_FILESIZE'			=> 'Размер файла аватары должен находиться в диапазоне от 0 до %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'Размеры отправленной аватары — %5$d×%6$d. Размеры аватары должны быть не менее %1$d×%2$d, но не более %3$d×%4$d. Все размеры указаны в пикселах.',

	'BACK_TO_TOP'			=> 'Наверх',
	'BACK_TO_PREV'			=> 'Вернуться на предыдущую страницу',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Ваш email-адрес в чёрном списке.',
	'BAN_TRIGGERED_BY_IP'	=> 'Ваш IP-адрес в чёрном списке.',
	'BAN_TRIGGERED_BY_USER'	=> 'Ваше имя пользователя в чёрном списке.',
	'BBCODE_GUIDE'			=> 'Помощь по BBCode',
	'BCC'					=> 'Скрытая копия',
	'BIRTHDAYS'				=> 'Дни рождения',
	'BOARD_BAN_PERM'		=> 'Вам закрыт доступ к форуму.',
	'BOARD_BAN_TIME'		=> 'Вам закрыт доступ к форуму до <strong>%1$s</strong>.',
	'BOARD_BAN_REASON'		=> '<br /><br />Причина: <strong>%s</strong><br /><br />',
	'BOARD_BAN_CONTACT'		=> 'Для получения дополнительной информации свяжитесь с %sадминистратором%s.',
	'BOARD_DISABLE'			=> 'Извините, но форум в настоящий момент недоступен',
	'BOARD_DISABLED'		=> 'Форум в настоящий момент отключен.',
	'BOARD_RULES'			=> 'Правила форума',
	'BOARD_UNAVAILABLE'		=> 'Форум временно недоступен. Попробуйте зайти через несколько минут.',
	'BROWSING_FORUM'		=> 'Сейчас этот раздел просматривают: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Сейчас этот раздел просматривают: %1$s и гости: %2$d',
	'BROWSING_FORUM_GUESTS'	=> 'Сейчас этот раздел просматривают: %1$s и гости: %2$d',
	'BYTES'					=> 'байт',

	'CANCEL'				=> 'Отмена',
	'CHANGE'				=> 'Изменить',
	'CHANGE_FONT_SIZE'		=> 'Изменить размер шрифта',
	'CLEAR'					=> 'Очистить',
	'CLICK_VIEW_PRIVMSG'	=> '%sПерейти в папку «Входящие»%s',
	'COLLAPSE_VIEW'			=> 'Свернуть',
	'CLOSE_WINDOW'			=> 'Закрыть окно',
	'COLOUR_SWATCH'			=> 'Палитра',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Подтверждение',
	'CONFIRM_CODE'			=> 'Код подтверждения',
	'CONFIRM_CODE_EXPLAIN'	=> 'Введите код в точности так, как вы его видите. Регистр символов не имеет значения.',
	'CONFIRM_CODE_WRONG'	=> 'Вы ввели неверный код подтверждения.',
	'CONFIRM_OPERATION'		=> 'Вы уверены, что хотите выполнить эту операцию?',
	'CONGRATULATIONS'		=> 'Поздравляем',
	'CONNECTION_FAILED'		=> 'Ошибка подключения.',
	'CONNECTION_SUCCESS'	=> 'Подключение успешно установлено.',
	'CREATION_TIME'			=> 'Время создания',
	'CURRENT_TIME'			=> 'Текущее время: %s',
	'CURRENT_TIMEZONE'		=> 'Часовой пояс: %1$s %2$s',

	'DAY'					=> 'День',
	'DAYS'					=> 'дней',
	'DEFAULT'				=> 'По умолчанию',
	'DELETE'				=> 'Удалить',
	'DELETE_ALL'			=> 'Удалить все',
	'DELETE_MARKED'			=> 'Удалить отмеченные',
	'DELETE_POST'			=> 'Удалить сообщение',
	'DELIMITER'				=> 'Разделитель',
	'DESCENDING'			=> 'по убыванию',
	'DISABLED'				=> 'Отключено',
	'DISPLAY'				=> 'Показать',
	'DISPLAY_GUESTS'		=> 'Показать гостей',
	'DISPLAY_MESSAGES'		=> 'Показать сообщения за',
	'DISPLAY_POSTS'			=> 'Показать сообщения за',
	'DISPLAY_TOPICS'		=> 'Показать темы за',
	'DOWNLOADED'			=> 'Скачиваний:',
	'DOWNLOAD_COUNT'		=> 'Скачиваний: %d',
	'DOWNLOAD_COUNTS'		=> 'Скачиваний: %d',
	'DOWNLOAD_COUNT_NONE'	=> 'Скачиваний: 0',
	'VIEWED_COUNT'			=> 'Просмотров: %d',
	'VIEWED_COUNTS'			=> 'Просмотров: %d',
	'VIEWED_COUNT_NONE'		=> 'Просмотров: 0',

	'EDIT_POST'							=> 'Редактировать сообщение',
	'EMAIL'								=> 'Email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Адрес email',
	'EMAIL_INVALID_EMAIL'				=> 'Введённый адрес email неверен.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ошибка при отправке email в <strong>строке %1$s</strong>. Ответ сервера: %2$s.',
	'EMPTY_SUBJECT'						=> 'При создании новой темы необходимо указать заголовок.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Вы должны указать тему нового сообщения.',
	'ENABLED'							=> 'Включено',
	'ENCLOSURE'							=> 'Ограничитель',
	'ENTER_USERNAME'					=> 'Введите имя пользователя',
	'ERR_CHANGING_DIRECTORY'			=> 'Не удалось сменить папку.',
	'ERR_CONNECTING_SERVER'				=> 'Ошибка подключения к серверу.',
	'ERR_JAB_AUTH'						=> 'Не удалось авторизоваться на сервере Jabber.',
	'ERR_JAB_CONNECT'					=> 'Не удалось подключиться к серверу Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Указано неверное имя пользователя или пароль.',
	'ERR_UNWATCHING'					=> 'При попытке отказаться от подписки возникла ошибка.',
	'ERR_WATCHING'						=> 'При попытке подписаться возникла ошибка.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Указанный путь к форуму неверен.',
	'EXPAND_VIEW'						=> 'Развернуть',
	'EXTENSION'							=> 'Расширение',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Расширение <strong>%s</strong> было запрещено, вложение больше недоступно.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Часто задаваемые вопросы',
	'FILENAME'				=> 'Имя файла',
	'FILESIZE'				=> 'Размер файла',
	'FILEDATE'				=> 'Дата создания файла',
	'FILE_COMMENT'			=> 'Комментарий к файлу',
	'FILE_NOT_FOUND'		=> 'Запрашиваемый файл не найден.',
	'FIND_USERNAME'			=> 'Найти пользователя',
	'FOLDER'				=> 'Папка',
	'FORGOT_PASS'			=> 'Забыли пароль?',
	'FORM_INVALID'			=> 'Ошибка отправки формы. Попробуйте ещё раз.',
	'FORM_INVALID_TOKEN'	=> 'Ошибка отправки формы. Ваш браузер должен поддерживать JavaScript.',
	'FORUM'					=> 'Раздел',
	'FORUMS'				=> 'Форум',
	'FORUMS_MARKED'			=> 'Разделы отмечены как прочтённые',
	'FORUM_CAT'				=> 'Категория',
	'FORUM_DESC'			=> 'Описание',
	'FORUM_INDEX'			=> 'Список разделов',
	'FORUM_LINK'			=> 'Ссылка на раздел',
	'FORUM_LOCKED'			=> 'Раздел закрыт',
	'FORUM_RULES'			=> 'Правила раздела',
	'FORUM_RULES_LINK'		=> 'Посмотреть правила раздела',
	'FROM'					=> 'из',
	'FSOCK_DISABLED'		=> 'Действие не может быть завершено, поскольку функция <var>fsockopen</var> отключена или запрашиваемый сервер не найден.',
	'FSOCK_TIMEOUT'			=> 'Таймаут соединения.',

	'FTP_FSOCK_HOST'				=> 'FTP-сервер',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-сервер для соединения с сайтом.',
	'FTP_FSOCK_PASSWORD'			=> 'Пароль FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Пароль для входа на FTP-сервер.',
	'FTP_FSOCK_PORT'				=> 'Порт FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Порт для соединения с FTP-сервером.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Путь к phpBBex',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Путь к каталогу, содержащему phpBBex, относительно корня сайта.',
	'FTP_FSOCK_TIMEOUT'				=> 'Тайм-аут FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Время в секундах, в течение которого система будет ожидать ответа от FTP-сервера.',
	'FTP_FSOCK_USERNAME'			=> 'Имя пользователя FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Имя пользователя для соединения с FTP-сервером.',

	'FTP_HOST'					=> 'FTP-сервер',
	'FTP_HOST_EXPLAIN'			=> 'FTP-сервер для соединения с сайтом.',
	'FTP_PASSWORD'				=> 'Пароль FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Пароль для входа на FTP-сервер.',
	'FTP_PORT'					=> 'Порт FTP',
	'FTP_PORT_EXPLAIN'			=> 'Порт для соединения с FTP-сервером.',
	'FTP_ROOT_PATH'				=> 'Путь к phpBBex',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Путь к каталогу, содержащему phpBBex, относительно корня сайта.',
	'FTP_TIMEOUT'				=> 'Тайм-аут FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Время в секундах, в течение которого система будет ожидать ответа от FTP-сервера.',
	'FTP_USERNAME'				=> 'Имя пользователя FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Имя пользователя для соединения с FTP-сервером.',

	'GENERAL_ERROR'				=> 'Общая ошибка',
	'GB'						=> 'ГБ',
	'GIB'						=> 'ГБ',
	'GO'						=> 'Перейти',
	'GOTO_PAGE'					=> 'На страницу',
	'GROUP'						=> 'Группа',
	'GROUPS'					=> 'Группы',
	'GROUP_ERR_TYPE'			=> 'Выбран несоответствующий тип группы.',
	'GROUP_ERR_USERNAME'		=> 'Не указано имя группы.',
	'GROUP_ERR_USER_LONG'		=> 'Имя группы не может быть длиннее 60 символов. Указанное имя группы слишком длинное.',
	'GUEST'						=> 'Гость',
	'G_ADMINISTRATORS'			=> 'Администраторы',
	'G_BOTS'					=> 'Боты',
	'G_GUESTS'					=> 'Гости',
	'G_REGISTERED'				=> 'Зарегистрированные',
	'G_GLOBAL_MODERATORS'		=> 'Супермодераторы',
	'G_NEWLY_REGISTERED'		=> 'Новые',

	'HIDE'							=> 'Скрыть',
	'HIDE_GUESTS'					=> 'Скрыть гостей',
	'HIDE_ME'						=> 'Скрыть моё пребывание на форуме в этот раз',
	'HOURS'							=> 'часов',
	'HOME'							=> 'На главную',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Если',
	'IMAGE'						=> 'Изображение',
	'IMAGE_FILETYPE_INVALID'	=> 'Тип файла изображения %d не поддерживается для MIME-типа %s.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Несовпадение типа изображения: ожидаемое расширение %1$s вместо полученного %2$s.',
	'IN'						=> 'в разделе',
	'INDEX'						=> 'Главная страница',
	'INFORMATION'				=> 'Информация',
	'INTERESTS'					=> 'Интересы',
	'INVALID_DIGEST_CHALLENGE'	=> 'Неверный запрос аутентификации.',
	'INVALID_EMAIL_LOG'			=> 'Возможно, введён неверный адрес email: <strong>%s</strong>',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Ваш IP-адрес %1$s был внесён в черный список и заблокирован. Для получения дополнительной информации перейдите по ссылке <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Зарегистрирован',
	'JUMP_PAGE'				=> 'Введите номер страницы',
	'JUMP_TO'				=> 'Перейти',
	'JUMP_TO_PAGE'			=> 'Перейти на страницу…',

	'KB'					=> 'КБ',
	'KIB'					=> 'КБ',

	'LAST_POST'							=> 'Последнее сообщение',
	'LAST_UPDATED'						=> 'Последнее изменение',
	'LAST_VISIT'						=> 'Последнее посещение',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Расширение LDAP недоступно.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Не удалось соединиться с сервером LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Произошла ошибка при поиске в директории LDAP.',
	'LEGEND'							=> 'Легенда',
	'LOCATION'							=> 'Откуда',
	'LOCK_POST'							=> 'Запрет редактирования',
	'LOCK_POST_EXPLAIN'					=> 'запрет редактирования',
	'LOCK_TOPIC'						=> 'Закрыть тему',
	'LOGIN'								=> 'Вход',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Вы превысили максимально допустимое количество попыток входа. Теперь, кроме имени пользователя и пароля, вы должны пройти проверку средством против спам-ботов.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Apache не смог вас аутентифицировать.',
	'LOGIN_ERROR_INACTIVE'				=> 'Указанное имя пользователя не активировано. Если вы испытываете трудности с активацией своей учётной записи, то свяжитесь с %sадминистратором%s.',
	'LOGIN_ERROR_PASSWORD'				=> 'Вы ввели неверный пароль. Проверьте его и попробуйте ввести ещё раз. Если проблема со входом останется, то свяжитесь с %sадминистратором%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'При обновлении форума не удалось преобразовать ваш пароль. Вы можете %sзапросить новый пароль%s. Если вы продолжаете испытывать трудности, то свяжитесь с то свяжитесь с %sадминистратором%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Вы ввели неверное имя пользователя. Проверьте его и попробуйте ввести ещё раз. Если проблема со входом останется, то сообщите об этом %sадминистратору%s.',
	'LOGIN_FORUM'						=> 'Для просмотра или размещения сообщений в этом разделе необходимо ввести пароль.',
	'LOGIN_INFO'						=> 'Для входа на форум вы должны быть зарегистрированы. Регистрация занимает всего несколько минут, но предоставляет вам более широкие возможности. Прежде чем зарегистрироваться, вам следует ознакомиться с правилами, принятыми на форуме. Помните, что ваше присутствие на форуме означает согласие со всеми правилами.',
	'LOGIN_EXPLAIN_VIEWINDEX'			=> 'Авторизуйтесь для просмотра списка разделов',
	'LOGIN_EXPLAIN_VIEWFORUM'			=> 'Авторизуйтесь для просмотра этого раздела',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Авторизуйтесь для просмотра списка пользователей, находящихся сейчас на форуме',
	'LOGIN_EXPLAIN_VIEWPAGE'			=> 'Авторизуйтесь для просмотра этой страницы',
	'LOGOUT'							=> 'Выход',
	'LOGOUT_USER'						=> 'Выход [ %s ]',
	'LOG_ME_IN'							=> 'Автоматически входить при каждом посещении',

	'MARK'					=> 'Отметить',
	'MARK_ALL'				=> 'Отметить все',
	'MARK_FORUMS_READ'		=> 'Отметить разделы как прочтённые',
	'MARK_SUBFORUMS_READ'	=> 'Отметить подразделы как прочтённые',
	'MB'					=> 'MБ',
	'MIB'					=> 'МБ',
	'MCP'					=> 'Панель модератора',
	'MEMBERLIST'			=> 'Пользователи',
	'MEMBERLIST_EXPLAIN'	=> 'Просмотр всего списка пользователей',
	'MERGE'					=> 'Объединить',
	'MERGE_POSTS'			=> 'Перенести сообщения',
	'MERGE_TOPIC'			=> 'Объединить тему',
	'MESSAGE'				=> 'Сообщение',
	'MESSAGES'				=> 'Сообщения',
	'MESSAGE_BODY'			=> 'Текст сообщения',
	'MINUTES'				=> 'минут',
	'MODERATE'				=> 'Модерировать',
	'MODERATOR'				=> 'Модератор',
	'MODERATORS'			=> 'Модераторы',
	'MODULE_NOT_ACCESS'		=> 'Модуль недоступен',
	'MODULE_NOT_FIND'		=> 'Не удалось найти модуль %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Файл модуля %s не содержит необходимого класса [%s]',
	'MONTH'					=> 'Месяц',
	'MOVE'					=> 'Переместить',

	'NA'						=> 'Нет',
	'NEWEST_USER'				=> 'Новый пользователь: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Новое сообщение',
	'NEW_MESSAGES'				=> 'Новые сообщения',
	'NEW_PM'					=> 'Новых ЛС: %d',
	'NEW_PMS'					=> 'Новых ЛС: %d',
	'NEW_POST'					=> 'Новое сообщение', // Больше не используется
	'NEW_POSTS'					=> 'Новые сообщения', // Больше не используется
	'NEXT'						=> 'След.',		// Used in pagination
	'NEXT_STEP'					=> 'Далее',
	'NEVER'						=> 'Никогда',
	'NO'						=> 'Нет',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Вы не можете управлять этой группой.',
	'NOT_AUTHORISED'			=> 'У вас нет доступа в эту часть форума.',
	'NOT_WATCHING_FORUM'		=> 'Вы больше не подписаны на обновления в этом разделе.',
	'NOT_WATCHING_TOPIC'		=> 'Вы больше не подписаны на эту тему.',
	'NOTIFY_ADMIN'				=> 'Уведомите администратора форума или вебмастера.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Уведомите администратора форума или вебмастера: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Вам запрещён доступ к этому файлу.',
	'NO_ACTION'					=> 'Действие не определено.',
	'NO_ADMINISTRATORS'			=> 'Администраторы отсутствуют.',
	'NO_AUTH_ADMIN'				=> 'Вы не имеете прав доступа к панели администратора.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Вы не можете повторно авторизоваться как другой пользователь.',
	'NO_AUTH_OPERATION'			=> 'Вы не имеете необходимых прав доступа для завершения этой операции.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Не удалось соединиться с SMTP-сервером: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Сегодня нет дней рождения.',
	'NO_EMAIL_MESSAGE'			=> 'Отсутствует текст сообщения.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Не удалось получить ответ от почтового сервера.',
	'NO_EMAIL_SUBJECT'			=> 'Не указана тема сообщения.',
	'NO_FORUM'					=> 'Запрошенного раздела не существует.',
	'NO_FORUMS'					=> 'На этом сайте нет разделов.',
	'NO_GROUP'					=> 'Запрошенной группы не существует.',
	'NO_GROUP_MEMBERS'			=> 'В настоящее время в этой группе нет ни одного пользователя.',
	'NO_IPS_DEFINED'			=> 'Не определён IP-адрес или имя хоста',
	'NO_MEMBERS'				=> 'Не найдено ни одного пользователя по заданным критериям',
	'NO_MESSAGES'				=> 'Нет сообщений',
	'NO_MODE'					=> 'Не указан режим.',
	'NO_MODERATORS'				=> 'Модераторы отсутствуют.',
	'NO_NEW_MESSAGES'			=> 'Нет новых сообщений',
	'NO_NEW_PM'					=> 'Новых ЛС: 0',
	'NO_NEW_POSTS'				=> 'Нет новых сообщений', // Больше не используется
	'NO_ONLINE_USERS'			=> 'Нет пользователей онлайн',
	'NO_POSTS'					=> 'Нет сообщений',
	'NO_POSTS_TIME_FRAME'		=> 'В теме нет сообщений за выбранный период времени.',
	'NO_FEED_ENABLED'			=> 'Каналы новостей недоступны на этом форуме.',
	'NO_FEED'					=> 'Запрашиваемый канал новостей недоступен.',
	'NO_STYLE_DATA'				=> 'Невозможно получить данные о стиле',
	'NO_SUBJECT'				=> 'Не указана тема',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Указанный поисковый механизм отсутствует.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Метод аутентификации не поддерживается.',
	'NO_TOPIC'					=> 'Запрошенной темы не существует.',
	'NO_TOPIC_FORUM'			=> 'Данная тема или раздел больше не существует.',
	'NO_TOPICS'					=> 'В этом разделе нет сообщений.',
	'NO_TOPICS_TIME_FRAME'		=> 'В разделе нет тем за выбранный период времени.',
	'NO_UNREAD_PM'				=> 'Нет непрочитанных личных сообщений',
	'NO_UNREAD_POSTS'			=> 'Нет непрочитанных сообщений',
	'NO_UPLOAD_FORM_FOUND'		=> 'Закачивание файла инициировано, но доступный для закачки файл не найден.',
	'NO_USER'					=> 'Запрашиваемого пользователя не существует.',
	'NO_USERS'					=> 'Запрашиваемых пользователей не существует.',
	'NO_USER_SPECIFIED'			=> 'Имя пользователя не определено.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'	=> [
		0		=> 'Нет сообщений в очереди',	// 0
		1		=> 'Сообщений в очереди: 1',	// 1
		2		=> 'Сообщений в очереди: %d',	// 2+
	],

	'OCCUPATION'				=> 'Род занятий',
	'OFFLINE'					=> 'Офлайн',
	'ONLINE'					=> 'Онлайн',
	'ONLINE_BUDDIES'			=> 'Друзья',
	'OPTIONS'					=> 'Настройки',

	'ONLINE_TOTAL_STR'			=> 'Всего посетителей: <strong>%d</strong>, из них: ',
	'ONLINE_HIDDEN_USERS'		=> [0 => '0 скрытых', 1 => '%d скрытый', 2 => '%d скрытых'],
	'ONLINE_REG_USERS'			=> [0 => '0 зарегистрированных', 1 => '%d зарегистрированный', 2 => '%d зарегистрированных'],
	'ONLINE_GUEST_USERS'		=> [0 => '0 гостей', 1 => '%d гость', 2 => '%d гостя', 5 => '%d гостей', 21 => '%d гость', 22 => '%d гостя', 25 => '%d гостей', 31 => '%d гость', 32 => '%d гостя', 35 => '%d гостей'],
	'ONLINE_BOT_USERS'			=> [0 => '0 ботов', 1 => '%d бот', 2 => '%d бота', 5 => '%d ботов', 21 => '%d бот', 22 => '%d бота', 25 => '%d ботов', 31 => '%d бот', 32 => '%d бота', 35 => '%d ботов'],

	'PAGE_OF'				=> 'Страница %1$d из %2$d',
	'PASSWORD'				=> 'Пароль',
 	'PIXEL'					=> 'пикс.',
	'PM'					=> 'Личное сообщение',
	'PM_REPORTED'			=> 'Нажмите для просмотра жалобы',
	'POST'					=> 'Сообщение',
	'POST_ANNOUNCEMENT'		=> 'Объявление',
	'POST_STICKY'			=> 'Закреплённая',
	'POSTED'				=> 'Добавлено',
	'POSTED_IN_FORUM'		=> 'в',
	'POSTED_ON_DATE'		=> '',
	'POSTS'					=> 'Сообщения',
	'POSTS_UNAPPROVED'		=> 'По крайней мере одно сообщение в этой теме не было проверено.',
	'POST_BY_AUTHOR'		=> '',
	'POST_BY_FOE'			=> 'Автором этого сообщения является <strong>%1$s</strong>, находящийся в вашем чёрном списке. %2$sПоказать это сообщение%3$s.',
	'POST_DAY'				=> '%.2f сообщений в день',
	'POST_DETAILS'			=> 'Информация о сообщении',
	'POST_NEW_TOPIC'		=> 'Начать новую тему',
	'POST_PCT'				=> '%.2f%% всех сообщений',
	'POST_PCT_ACTIVE'		=> '%.2f%% сообщений пользователя',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% ваших сообщений',
	'POST_REPLY'			=> 'Ответить',
	'POST_REPORTED'			=> 'Просмотреть жалобу',
	'POST_SUBJECT'			=> 'Заголовок сообщения',
	'POST_TIME'				=> 'Время ответа',
	'POST_TOPIC'			=> 'Новая тема',
	'POST_UNAPPROVED'		=> 'Это сообщение ожидает проверки',
	'POWERED_BY'			=> 'Создано на основе <a href="//phpbbex.com/">phpBBex</a>',
	'PREVIEW'				=> 'Предпросмотр',
	'PREVIOUS'				=> 'Пред.',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Назад',
	'PRIVACY_POLICY'		=> 'Соглашение о конфиденциальности',
	'PRIVATE_MESSAGE'		=> 'Личное сообщение',
	'PRIVATE_MESSAGES'		=> 'Личные сообщения',
	'PRIVATE_MESSAGING'		=> 'Личные сообщения',
	'PROFILE'				=> 'Личная панель управления',

	'RANK'						=> 'Звание',
	'READ_PROFILE'				=> 'Профиль',
	'REASON'					=> 'Причина',
	'RECORD_ONLINE_USERS'		=> 'Больше всего посетителей (<strong>%1$s</strong>) здесь было %2$s',
	'REDIRECT'					=> 'Перенаправление',
	'REDIRECTS'					=> 'Переходов по ссылке',
	'REGISTER'					=> 'Регистрация',
	'REGISTERED_USERS'			=> 'Зарегистрированные пользователи:',
	'REMOVE'					=> 'Удалить',
	'REPLIES'					=> 'Ответы',
	'REPLY_WITH_QUOTE'			=> 'Ответить с цитатой',
	'REPORT_BY'					=> 'Источник',
	'REPORT_POST'				=> 'Пожаловаться на это сообщение',
	'RESEND_ACTIVATION'			=> 'Повторно выслать письмо для активации учётной записи',
	'RESET'						=> 'Вернуть',
	'RESTORE_PERMISSIONS'		=> 'Восстановить права',
	'RETURN_INDEX'				=> '%sВернуться на главную страницу%s',
	'RETURN_FORUM'				=> '%sВернуться в раздел%s',
	'RETURN_PAGE'				=> '%sВернуться на предыдущую страницу%s',
	'RETURN_TOPIC'				=> '%sВернуться в тему%s',
	'RETURN_TO'					=> 'Вернуться в',
	'FEED'						=> 'Канал',
	'FEED_NEWS'					=> 'Новости',
 	'FEED_TOPICS_ACTIVE'		=> 'Активные темы',
 	'FEED_TOPICS_NEW'			=> 'Новые темы',
 	'FEED_OVERALL'				=> 'Новые сообщения',
	'RULES_ATTACH_CAN'			=> 'Вы <strong>можете</strong> добавлять вложения',
	'RULES_ATTACH_CANNOT'		=> 'Вы <strong>не можете</strong> добавлять вложения',
	'RULES_DELETE_CAN'			=> 'Вы <strong>можете</strong> удалять свои сообщения',
	'RULES_DELETE_CANNOT'		=> 'Вы <strong>не можете</strong> удалять свои сообщения',
	'RULES_DOWNLOAD_CAN'		=> 'Вы <strong>можете</strong> скачивать вложения',
	'RULES_DOWNLOAD_CANNOT'		=> 'Вы <strong>не можете</strong> скачивать вложения',
	'RULES_EDIT_CAN'			=> 'Вы <strong>можете</strong> редактировать свои сообщения',
	'RULES_EDIT_CANNOT'			=> 'Вы <strong>не можете</strong> редактировать свои сообщения',
	'RULES_LOCK_CAN'			=> 'Вы <strong>можете</strong> закрывать свои темы',
	'RULES_LOCK_CANNOT'			=> 'Вы <strong>не можете</strong> закрывать свои темы',
	'RULES_POST_CAN'			=> 'Вы <strong>можете</strong> начинать темы',
	'RULES_POST_CANNOT'			=> 'Вы <strong>не можете</strong> начинать темы',
	'RULES_REPLY_CAN'			=> 'Вы <strong>можете</strong> отвечать на сообщения',
	'RULES_REPLY_CANNOT'		=> 'Вы <strong>не можете</strong> отвечать на сообщения',
	'RULES_VOTE_CAN'			=> 'Вы <strong>можете</strong> голосовать в опросах',
	'RULES_VOTE_CANNOT'			=> 'Вы <strong>не можете</strong> голосовать в опросах',

	'SEARCH'					=> 'Поиск',
	'SEARCH_MINI'				=> 'Поиск…',
	'SEARCH_ADV'				=> 'Расширенный поиск',
	'SEARCH_ADV_EXPLAIN'		=> 'Параметры расширенного поиска',
	'SEARCH_KEYWORDS'			=> 'Ключевые слова',
	'SEARCHING_FORUMS'			=> 'Поиск по форуму',
	'SEARCH_ACTIVE_TOPICS'		=> 'Активные темы',
	'SEARCH_FOR'				=> 'Найти',
	'SEARCH_FORUM'				=> 'Поиск в разделе…',
	'SEARCH_NEW'				=> 'Новые сообщения',
	'SEARCH_POSTS_BY'			=> 'Искать сообщения',
	'SEARCH_SELF'				=> 'Ваши сообщения',
	'SEARCH_SELF_TOPICS'		=> 'Ваши темы',
	'SEARCH_TOPIC'				=> 'Поиск в теме…',
	'SEARCH_UNANSWERED'			=> 'Темы без ответов',
	'SEARCH_UNREAD'				=> 'Непрочитанные темы',
	'SEARCH_USER_POSTS'			=> 'Найти сообщения пользователя',
	'SECONDS'					=> 'секунд',
	'SELECT'					=> 'Выбор',
	'SELECT_ALL_CODE'			=> 'Выделить всё',
	'SELECT_DESTINATION_FORUM'	=> 'Выберите раздел назначения',
	'SELECT_FORUM'				=> 'Выберите раздел',
	'SEND_EMAIL'				=> 'Отправить email',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Отправить письмо пользователю',	// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> Email UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Отправить личное сообщение',
	'SETTINGS'					=> 'Настройки',
	'SIGNATURE'					=> 'Подпись',
	'SKIP'						=> 'Пропустить',
	'SKYPE'						=> 'Skype',
	'TELEGRAM'					=> 'Telegram',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-сервер не поддерживает аутентификацию.',
	'SORRY_AUTH_READ'			=> 'Вы не авторизованы для чтения этого раздела.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Вы не авторизованы для скачивания этого вложения.',
	'SORT_BY'					=> 'Поле сортировки',
	'SORT_JOINED'				=> 'Дата регистрации',
	'SORT_LOCATION'				=> 'Откуда',
	'SORT_RANK'					=> 'Звание',
	'SORT_POSTS'				=> 'Сообщения',
	'SORT_TOPIC_TITLE'			=> 'Название темы',
	'SORT_USERNAME'				=> 'Имя пользователя',
	'SPLIT_TOPIC'				=> 'Разделить тему',
	'SQL_ERROR_OCCURRED'		=> 'Произошла ошибка SQL при выборке на этой странице. Пожалуйста, сообщите %sадминистратору%s, если ошибка будет повторяться.',
	'STATISTICS'				=> 'Статистика',
	'START_WATCHING_FORUM'		=> 'Подписаться на раздел',
	'START_WATCHING_TOPIC'		=> 'Подписаться на тему',
	'STOP_WATCHING_FORUM'		=> 'Отписаться от раздела',
	'STOP_WATCHING_TOPIC'		=> 'Отписаться от темы',
	'SUBFORUM'					=> 'Подраздел',
	'SUBFORUMS'					=> 'Подразделы',
	'SUBJECT'					=> 'Заголовок',
	'SUBMIT'					=> 'Отправить',

	'TB'				=> 'ТБ',
	'TERMS_OF_USE'		=> 'Условия использования',
	'TEST_CONNECTION'	=> 'Проверить подключение',
	'THE_TEAM'			=> 'Наша команда',
	'TIB'				=> 'ТБ',
	'TIME'				=> 'Время',

	'TOO_LARGE'					=> 'Введённое значение слишком велико.',
	'TOO_LARGE_MAX_RECIPIENTS'	=> 'Введённое значение настройки <strong>Максимальное разрешённое число получателей ЛС</strong> слишком велико.',

	'TOO_LONG'			=> 'Введённое значение слишком длинное.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Введённый код подтверждения слишком длинный.',
	'TOO_LONG_DATEFORMAT'			=> 'Введённый формат даты слишком длинный.',
	'TOO_LONG_ICQ'					=> 'Номер ICQ слишком длинный.',
	'TOO_LONG_INTERESTS'			=> 'Слишком длинная строка интересов.',
	'TOO_LONG_JABBER'				=> 'Имя учётной записи Jabber слишком длинное.',
	'TOO_LONG_LOCATION'				=> 'Строка «Откуда» слишком длинная.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Введённый пароль слишком длинный.',
	'TOO_LONG_OCCUPATION'			=> 'Строка «Род занятий» слишком длинная.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Подтверждение пароля слишком длинное.',
	'TOO_LONG_USER_PASSWORD'		=> 'Пароль слишком длинный.',
	'TOO_LONG_USERNAME'				=> 'Имя пользователя слишком длинное.',
	'TOO_LONG_EMAIL'				=> 'Адрес email слишком длинный.',
	'TOO_LONG_WEBSITE'				=> 'Адрес сайта слишком длинный.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Вы выбрали слишком много вариантов ответа при голосовании.',

	'TOO_SHORT'						=> 'Введённое значение слишком короткое.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Введённый код подтверждения слишком короткий.',
	'TOO_SHORT_DATEFORMAT'			=> 'Введённый формат даты слишком короткий.',
	'TOO_SHORT_ICQ'					=> 'Номер ICQ слишком короткий.',
	'TOO_SHORT_INTERESTS'			=> 'Слишком короткая строка интересов.',
	'TOO_SHORT_JABBER'				=> 'Имя учётной записи Jabber слишком короткое.',
	'TOO_SHORT_LOCATION'			=> 'Строка «Откуда» слишком короткая.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Введённый пароль слишком короткий.',
	'TOO_SHORT_OCCUPATION'			=> 'Строка «Род занятий» слишком короткая.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Подтверждение пароля слишком короткое.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Пароль слишком короткий.',
	'TOO_SHORT_USERNAME'			=> 'Имя пользователя слишком короткое.',
	'TOO_SHORT_EMAIL'				=> 'Адрес email слишком короткий.',
	'TOO_SHORT_WEBSITE'				=> 'Адрес сайта слишком короткий.',

	'TOO_SMALL'						=> 'Введённое значение слишком мало.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Введённое значение настройки <strong>Максимальное разрешённое число получателей ЛС</strong> слишком мало.',

	'TOPIC'				=> 'Тема',
	'TOPICS'			=> 'Темы',
	'TOPICS_UNAPPROVED'	=> 'По крайне мере одна тема в этом разделе не была одобрена.',
	'TOPIC_ICON'		=> 'Иконка',
	'TOPIC_LOCKED'		=> 'Эта тема закрыта, вы не можете редактировать и оставлять сообщения в ней.',
	'TOPIC_LOCKED_SHORT'=> 'Закрыто',
	'TOPIC_MOVED'		=> 'Перенесённая',
	'TOPIC_POSTER'		=> 'Автор темы',
	'TOPIC_REVIEW'		=> 'Обзор темы',
	'TOPIC_TITLE'		=> 'Название темы',
	'TOPIC_UNAPPROVED'	=> 'Данная тема не была одобрена',
	'TOTAL_ATTACHMENTS'	=> 'Вложения',
	'TOTAL_LOG'			=> '1 лог',
	'TOTAL_LOGS'		=> 'Логов: %d',
	'TOTAL_NO_PM'		=> 'Всего 0 личных сообщений',
	'TOTAL_PM'			=> 'Всего 1 личное сообщение',
	'TOTAL_PMS'			=> 'Всего %d личных сообщений',
	'TOTAL_POSTS'		=> 'Всего сообщений',
	'TOTAL_POSTS_OTHER'	=> 'Всего сообщений: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Всего сообщений: <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'На данную тему поступили жалобы',
	'TOTAL_TOPICS_OTHER'=> 'Тем: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Тем: <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Пользователей: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Пользователей: <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Отслеженные ошибки PHP: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Не удалось определить размеры изображения. Проверьте правильность введённого адреса URL.',
	'UNABLE_TO_DELIVER_FILE'=> 'Не удалось доставить файл.',
	'UNKNOWN_BROWSER'		=> 'Неизвестный браузер',
	'UNMARK_ALL'			=> 'Снять выделение',
	'UNREAD_MESSAGES'		=> 'Непрочитанные сообщения',
	'UNREAD_PM'				=> 'Непрочитанных сообщений: <strong>%d</strong>',
	'UNREAD_PMS'			=> 'Непрочитанных сообщений: <strong>%d</strong>',
	'UNREAD_POST'			=> 'Непрочитанное сообщение',
	'UNREAD_POSTS'			=> 'Непрочитанные сообщения',
	'UNWATCH_FORUM_CONFIRM'		=> 'Вы действительно хотите отписаться от данного раздела?',
	'UNWATCH_FORUM_DETAILED'	=> 'Вы действительно хотите отписаться от раздела «%s»?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Вы действительно хотите отписаться от данной темы?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Вы действительно хотите отписаться от темы «%s»?',
	'UNWATCHED_FORUMS'			=> 'Вы больше не подписаны на выбранные разделы.',
	'UNWATCHED_TOPICS'			=> 'Вы больше не подписаны на выбранные темы.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Вы больше не подписаны на выбранное.',
	'UPDATE'				=> 'Обновить',
	'USERGROUPS'			=> 'Группы',
	'USERNAME'				=> 'Имя пользователя',
	'USERNAMES'				=> 'Имена пользователей',
	'USER_AVATAR'			=> 'Аватара',
	'USER_CANNOT_READ'		=> 'Вы не можете читать сообщения в этом разделе.',
	'USER_POST'				=> '%d сообщение',
	'USER_POSTS'			=> '%d сообщений',
	'USERS'					=> 'Пользователи',
	'USE_PERMISSIONS'		=> 'Проверить права',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Вам не разрешено использовать данную возможность. Возможно, вы недавно зарегистрировались на форуме или вам необходимо проявить больше активности на нём, чтобы получить такое право.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Просмотров:',
	'VIEWS'						=> 'Просмотры',
	'VIEW_BOOKMARKS'			=> 'Просмотреть закладки',
	'VIEW_FORUM_LOGS'			=> 'Просмотреть логи',
	'VIEW_LATEST_POST'			=> 'Перейти к последнему сообщению',
	'VIEW_NEWEST_POST'			=> 'Перейти к первому непрочитанному сообщению',
	'VIEW_NOTES'				=> 'Заметки о пользователе',
	'VIEW_ONLINE_TIME'			=> 'по активности за минуту',
	'VIEW_ONLINE_TIMES'			=> 'по активности за %d минут',
	'VIEW_TOPIC'				=> 'Просмотр темы',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Объявление: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Важная: ',
	'VIEW_TOPIC_LOCKED'			=> 'Закрыто: ',
	'VIEW_TOPIC_LOGS'			=> 'Просмотр логов',
	'VIEW_TOPIC_MOVED'			=> 'Перемещена: ',
	'VIEW_TOPIC_POLL'			=> 'Опрос: ',
	'VIEW_TOPIC_STICKY'			=> 'Закреплённая: ',
	'VISIT_WEBSITE'				=> 'Перейти на сайт',

	'WARNINGS'			=> 'Предупреждения',
	'WARN_USER'			=> 'Вынести предупреждение',
	'WATCH_FORUM_CONFIRM'	=> 'Вы действительно хотите подписаться на данный раздел?',
	'WATCH_FORUM_DETAILED'	=> 'Вы действительно хотите подписаться на раздел «%s»?',
	'WATCH_TOPIC_CONFIRM'	=> 'Вы действительно хотите подписаться на данную тему?',
	'WATCH_TOPIC_DETAILED'	=> 'Вы действительно хотите подписаться на тему «%s»?',
	'WELCOME_SUBJECT'	=> 'Добро пожаловать на форум «%s»',
	'WEBSITE'			=> 'Сайт',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Кто сейчас на форуме',
	'WRONG_PASSWORD'	=> 'Вы ввели неверный пароль.',

	'WRONG_DATA_COLOUR'			=> 'Введено неправильное значение цвета.',
	'WRONG_DATA_ICQ'			=> 'Введён неправильный номер ICQ.',
	'WRONG_DATA_JABBER'			=> 'Введено неправильное имя Jabber.',
	'WRONG_DATA_SKYPE'			=> 'Введено неправильное имя Skype.',
	'WRONG_DATA_TELEGRAM'		=> 'Введено неправильное имя Telegram.',
	'WRONG_DATA_LANG'			=> 'Указан неправильный язык.',
	'WRONG_DATA_WEBSITE'		=> 'Адрес сайта должен быть правильной ссылкой, включающей наименование протокола. Например, http://www.example.com/.',
	'WROTE'						=> 'писал(а)',

	'YEAR'				=> 'Год',
	'YEAR_MONTH_DAY'	=> '(ГГГГ-ММ-ДД)',
	'YES'				=> 'Да',
	'YOU_LAST_VISIT'	=> 'Предыдущее посещение: %s',
	'YOU_NEW_PM'		=> 'Вам пришло новое личное сообщение.',
	'YOU_NEW_PMS'		=> 'Вам пришли новые личные сообщения.',
	'YOU_NO_NEW_PM'		=> 'У вас нет новых личных сообщений.',

	'datetime'			=> [
		'TODAY'		=> 'Сегодня',
		'TOMORROW'	=> 'Завтра',
		'YESTERDAY'	=> 'Вчера',

		'AGO'		=> [
			0		=> '0 минут назад',
			1		=> '%d минуту назад',
			2		=> '%d минуты назад',
			5		=> '%d минут назад',
			21		=> '%d минуту назад',
			22		=> '%d минуты назад',
			25		=> '%d минут назад',
			31		=> '%d минуту назад',
			32		=> '%d минуты назад',
			35		=> '%d минут назад',
			41		=> '%d минуту назад',
			42		=> '%d минуты назад',
			45		=> '%d минут назад',
			51		=> '%d минуту назад',
			52		=> '%d минуты назад',
			55		=> '%d минут назад',
			60		=> '1 час назад',
		],

		'Sunday'	=> 'Воскресенье',
		'Monday'	=> 'Понедельник',
		'Tuesday'	=> 'Вторник',
		'Wednesday'	=> 'Среда',
		'Thursday'	=> 'Четверг',
		'Friday'	=> 'Пятница',
		'Saturday'	=> 'Суббота',

		'Sun'		=> 'Вс',
		'Mon'		=> 'Пн',
		'Tue'		=> 'Вт',
		'Wed'		=> 'Ср',
		'Thu'		=> 'Чт',
		'Fri'		=> 'Пт',
		'Sat'		=> 'Сб',

		'January'	=> 'Январь',
		'February'	=> 'Февраль',
		'March'		=> 'Март',
		'April'		=> 'Апрель',
		'May'		=> 'Май',
		'June'		=> 'Июнь',
		'July'		=> 'Июль',
		'August'	=> 'Август',
		'September'	=> 'Сентябрь',
		'October'	=> 'Октябрь',
		'November'	=> 'Ноябрь',
		'December'	=> 'Декабрь',

		'Jan'		=> 'января',
		'Feb'		=> 'февраля',
		'Mar'		=> 'марта',
		'Apr'		=> 'апреля',
		'May_short'	=> 'мая',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'июня',
		'Jul'		=> 'июля',
		'Aug'		=> 'августа',
		'Sep'		=> 'сентября',
		'Oct'		=> 'октября',
		'Nov'		=> 'ноября',
		'Dec'		=> 'декабря',
	],

	'tz' => [
		'-12'	=> 'UTC−12',
		'-11'	=> 'UTC−11',
		'-10'	=> 'UTC−10',
		'-9.5'	=> 'UTC−9:30',
		'-9'	=> 'UTC−9',
		'-8'	=> 'UTC−8',
		'-7'	=> 'UTC−7',
		'-6'	=> 'UTC−6',
		'-5'	=> 'UTC−5',
		'-4.5'	=> 'UTC−4:30',
		'-4'	=> 'UTC−4',
		'-3.5'	=> 'UTC−3:30',
		'-3'	=> 'UTC−3',
		'-2'	=> 'UTC−2',
		'-1'	=> 'UTC−1',
		'0'		=> 'UTC',
		'1'		=> 'UTC+1',
		'2'		=> 'UTC+2',
		'3'		=> 'UTC+3',
		'3.5'	=> 'UTC+3:30',
		'4'		=> 'UTC+4',
		'4.5'	=> 'UTC+4:30',
		'5'		=> 'UTC+5',
		'5.5'	=> 'UTC+5:30',
		'5.75'	=> 'UTC+5:45',
		'6'		=> 'UTC+6',
		'6.5'	=> 'UTC+6:30',
		'7'		=> 'UTC+7',
		'8'		=> 'UTC+8',
		'8.75'	=> 'UTC+8:45',
		'9'		=> 'UTC+9',
		'9.5'	=> 'UTC+9:30',
		'10'	=> 'UTC+10',
		'10.5'	=> 'UTC+10:30',
		'11'	=> 'UTC+11',
		'11.5'	=> 'UTC+11:30',
		'12'	=> 'UTC+12',
		'12.75'	=> 'UTC+12:45',
		'13'	=> 'UTC+13',
		'14'	=> 'UTC+14',
	],

	'DST'	=> '<abbr title="Летнее время">DST</abbr>',

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> [
		'|d.m.Y|{, H:i}'		=> 'Сегодня, 09:15 / 01.01.2012, 09:15',
		'|j M Y|{, G:i}'		=> 'Сегодня, 9:15 / 1 янв 2012, 9:15',
		'|D, j M Y|{, G:i}'		=> 'Сегодня, 9:15 / Вт, 1 янв 2012, 9:15',
		'j M Y{, G:i}'			=> '1 янв 2012, 9:15',
		'{H:i }d.m.Y'			=> '09:15 01.01.2012',
		'd.m.Y{, H:i}'			=> '01.01.2012, 09:15',
		'Y-m-d{ H:i}'			=> '2012-01-01 09:15',
	],

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'		=> '|d.m.Y|{, H:i}', // Сегодня, 10:06 / 24.04.2012, 10:06

	// User topics count
	'NUM_TOPICS_IN_QUEUE'		=> [
		0			=> 'Нет тем в очереди',	// 0
		1			=> '1 тема в очереди',	// 1
		2			=> '%d тем в очереди',	// 2+
	],
	'TOPIC_DAY'					=> '%.2f тем в день',
	'TOPIC_PCT'					=> '%.2f%% всех тем',
	'TOTAL_TOPICS'				=> 'Всего тем',

	// Posts merging
	'UPD_MERGED_AFTER'			=> 'Добавлено спустя %s:',
	'UPD_MERGED'				=> 'Добавлено %s:',

	// Time delta
	'D_SECONDS'					=> ['секунду', 'секунды', 'секунд'],
	'D_MINUTES'					=> ['минуту', 'минуты', 'минут'],
	'D_HOURS'					=> ['час', 'часа', 'часов'],
	'D_MDAY'					=> ['день', 'дня', 'дней'],
	'D_MON'						=> ['месяц', 'месяца', 'месяцев'],
	'D_YEAR'					=> ['год', 'года', 'лет'],

	// Genders
	'GENDER'					=> 'Пол',
	'GENDER_X'					=> 'Нет',
	'GENDER_M'					=> 'Мужской',
	'GENDER_F'					=> 'Женский',

	// Ratings
	'USER_RATING'				=> 'Репутация',
	'USER_RATED'				=> 'Лояльность',

	// Main menu
	'USER_CP'					=> 'Личное',
	'MODER_CP'					=> 'Модератору',
	'MODERATE_FORUM'			=> 'Модерировать раздел',
	'MODERATE_TOPIC'			=> 'Модерировать тему',
	'ADMIN_CP'					=> 'Админка',
	'OVERVIEW'					=> 'Обзор',
	'ATTACHMENTS'				=> 'Вложения',
	'BOOKMARKS'					=> 'Закладки',
	'DRAFTS'					=> 'Черновики',
	'SUBSCRIBED'				=> 'Подписки',
	'FRIENDS_AND_FOES'			=> 'Друзья и недруги',
	'PM_COMPOSE'				=> 'Новое сообщение',
	'PM_INBOX'					=> 'Входящие',
	'PM_OUTBOX'					=> 'Исходящие',
	'PM_SENTBOX'				=> 'Доставленные',

	// Memberlist filters
	'MEMBERLIST_ALL_USERS'		=> 'Все пользователи',
	'MEMBERLIST_ACTIVE_USERS'	=> 'Активные',
	'MEMBERLIST_INACTIVE_USERS'	=> 'Неактивные',
	'SEARCH_USERS'				=> 'Поиск пользователей',

	// Login via Email
	'USERNAME_OR_EMAIL'					=> 'Имя или email',
	'LOGIN_ERROR_USERNAME_OR_EMAIL'		=> 'Вы ввели неверное имя пользователя или email. Проверьте введённые данные и попробуйте ещё раз. Если проблема со входом останется, то сообщите об этом %sадминистратору%s.',
	'LOGIN_ERROR_EMAIL'					=> 'Вы ввели неверный email. Проверьте его и попробуйте ввести ещё раз. Если проблема со входом останется, то сообщите об этом %sадминистратору%s.',

	// Advanced Warnings
	'USER_WARNING'			=> 'Предупреждение',
	'WARNING_DAYS'			=> 'Дней',
	'REMARK'				=> 'Замечание',
	'WARNING'				=> 'Предупреждение',
	'BAN'					=> 'Бан',
	'PERMANENT_WARNING'		=> 'Бессрочное предупреждение',
	'WARNING_X_DAYS'		=> 'Предупреждение на %d дней',
	'PERMANENT_BAN'			=> 'Бессрочный бан',
	'BAN_X_DAYS'			=> 'Бан на %d дней',

	// Other
	'SOCIAL_SHARE_IN'		=> 'Поделиться в',
	'USER_WITH_US'			=> 'С нами',
	'SPOILER'				=> 'Спойлер',

]);
