<?php
/**
* @package phpBBex
* @copyright (c) 2015 phpBB Group, Vegalogic Software
* @license GNU Public License
*/

if (!defined('IN_PHPBB'))
{
	exit;
}

class phpbb_error_collector
{
	var $errors;

	function __construct()
	{
		$this->errors = [];
	}

	function install()
	{
		set_error_handler([&$this, 'error_handler']);
	}

	function uninstall()
	{
		restore_error_handler();
	}

	function error_handler($errno, $msg_text, $errfile, $errline)
	{
		$this->errors[] = [$errno, $msg_text, $errfile, $errline];
	}

	function format_errors()
	{
		$text = '';
		foreach ($this->errors as $error)
		{
			if (!empty($text))
			{
				$text .= "<br />\n";
			}

			[$errno, $msg_text, $errfile, $errline] = $error;

			// Prevent leakage of local path to phpBB install
			$errfile = phpbb_filter_root_path($errfile);

			$text .= "Errno $errno: $msg_text at $errfile line $errline";
		}

		return $text;
	}
}
